package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartPolicyGenerationResponse(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationResponse = {
    import StartPolicyGenerationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly =
    zio.aws.accessanalyzer.model.StartPolicyGenerationResponse
      .wrap(buildAwsValue())
}
object StartPolicyGenerationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.StartPolicyGenerationResponse =
      zio.aws.accessanalyzer.model.StartPolicyGenerationResponse(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationResponse
  ) extends zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.accessanalyzer.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationResponse
  ): zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly =
    new Wrapper(impl)
}
