package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Token, Integer, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListFindingsRequest(
    analyzerArn: AnalyzerArn,
    filter: Option[Map[String, zio.aws.accessanalyzer.model.Criterion]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[Token] = None,
    sort: Option[zio.aws.accessanalyzer.model.SortCriteria] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.filter)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sort.map(value => value.buildAwsValue()))(_.sort)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ListFindingsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListFindingsRequest =
      zio.aws.accessanalyzer.model.ListFindingsRequest(
        analyzerArn,
        filter.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sort.map(value => value.asEditable)
      )
    def analyzerArn: AnalyzerArn
    def filter
        : Option[Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[Token]
    def sort: Option[zio.aws.accessanalyzer.model.SortCriteria.ReadOnly]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getFilter: ZIO[Any, AwsError, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSort: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SortCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("sort", sort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
  ) extends zio.aws.accessanalyzer.model.ListFindingsRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val filter
        : Option[Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]] =
      scala
        .Option(impl.filter())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.accessanalyzer.model.Criterion
                .wrap(value)
            })
            .toMap
        )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.accessanalyzer.model.primitives.Integer(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val sort
        : Option[zio.aws.accessanalyzer.model.SortCriteria.ReadOnly] = scala
      .Option(impl.sort())
      .map(value => zio.aws.accessanalyzer.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
  ): zio.aws.accessanalyzer.model.ListFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
