package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait Locale {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.Locale
}
object Locale {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.Locale
  ): zio.aws.accessanalyzer.model.Locale = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.DE =>
      val r = DE
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.EN =>
      val r = EN
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.ES =>
      val r = ES
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.FR =>
      val r = FR
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.IT =>
      val r = IT
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.JA =>
      val r = JA
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.KO =>
      val r = KO
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.PT_BR =>
      val r = PT_BR
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.ZH_CN =>
      val r = ZH_CN
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Locale.ZH_TW =>
      val r = ZH_TW
      r
  }
  case object unknownToSdkVersion extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.UNKNOWN_TO_SDK_VERSION
  }
  case object DE extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.DE
  }
  case object EN extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.EN
  }
  case object ES extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.ES
  }
  case object FR extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.FR
  }
  case object IT extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.IT
  }
  case object JA extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.JA
  }
  case object KO extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.KO
  }
  case object PT_BR extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.PT_BR
  }
  case object ZH_CN extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.ZH_CN
  }
  case object ZH_TW extends zio.aws.accessanalyzer.model.Locale {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Locale =
      software.amazon.awssdk.services.accessanalyzer.model.Locale.ZH_TW
  }
}
