package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StatusReason(code: zio.aws.accessanalyzer.model.ReasonCode) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.StatusReason = {
    import StatusReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.StatusReason
      .builder()
      .code(code.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.StatusReason.ReadOnly =
    zio.aws.accessanalyzer.model.StatusReason.wrap(buildAwsValue())
}
object StatusReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.StatusReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.StatusReason =
      zio.aws.accessanalyzer.model.StatusReason(code)
    def code: zio.aws.accessanalyzer.model.ReasonCode
    def getCode: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.ReasonCode] =
      ZIO.succeed(code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StatusReason
  ) extends zio.aws.accessanalyzer.model.StatusReason.ReadOnly {
    override val code: zio.aws.accessanalyzer.model.ReasonCode =
      zio.aws.accessanalyzer.model.ReasonCode.wrap(impl.code())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StatusReason
  ): zio.aws.accessanalyzer.model.StatusReason.ReadOnly = new Wrapper(impl)
}
