package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  ResourceArn,
  FindingId,
  AnalyzerArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateFindingsRequest(
    analyzerArn: AnalyzerArn,
    clientToken: Option[String] = None,
    ids: Option[Iterable[FindingId]] = None,
    resourceArn: Option[ResourceArn] = None,
    status: zio.aws.accessanalyzer.model.FindingStatusUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest = {
    import UpdateFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            FindingId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.UpdateFindingsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.UpdateFindingsRequest.wrap(buildAwsValue())
}
object UpdateFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.UpdateFindingsRequest =
      zio.aws.accessanalyzer.model.UpdateFindingsRequest(
        analyzerArn,
        clientToken.map(value => value),
        ids.map(value => value),
        resourceArn.map(value => value),
        status
      )
    def analyzerArn: AnalyzerArn
    def clientToken: Option[String]
    def ids: Option[List[FindingId]]
    def resourceArn: Option[ResourceArn]
    def status: zio.aws.accessanalyzer.model.FindingStatusUpdate
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIds: ZIO[Any, AwsError, List[FindingId]] =
      AwsError.unwrapOptionField("ids", ids)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingStatusUpdate] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
  ) extends zio.aws.accessanalyzer.model.UpdateFindingsRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val ids: Option[List[FindingId]] = scala
      .Option(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.primitives.FindingId(item)
        }.toList
      )
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.accessanalyzer.model.primitives.ResourceArn(value))
    override val status: zio.aws.accessanalyzer.model.FindingStatusUpdate =
      zio.aws.accessanalyzer.model.FindingStatusUpdate.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
  ): zio.aws.accessanalyzer.model.UpdateFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
