package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{FindingId, AnalyzerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetFindingRequest(analyzerArn: AnalyzerArn, id: FindingId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest = {
    import GetFindingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .id(FindingId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GetFindingRequest.ReadOnly =
    zio.aws.accessanalyzer.model.GetFindingRequest.wrap(buildAwsValue())
}
object GetFindingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetFindingRequest =
      zio.aws.accessanalyzer.model.GetFindingRequest(analyzerArn, id)
    def analyzerArn: AnalyzerArn
    def id: FindingId
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getId: ZIO[Any, Nothing, FindingId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest
  ) extends zio.aws.accessanalyzer.model.GetFindingRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val id: FindingId =
      zio.aws.accessanalyzer.model.primitives.FindingId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest
  ): zio.aws.accessanalyzer.model.GetFindingRequest.ReadOnly = new Wrapper(impl)
}
