package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetFindingResponse(
    finding: Option[zio.aws.accessanalyzer.model.Finding] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse = {
    import GetFindingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse
      .builder()
      .optionallyWith(finding.map(value => value.buildAwsValue()))(_.finding)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly =
    zio.aws.accessanalyzer.model.GetFindingResponse.wrap(buildAwsValue())
}
object GetFindingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetFindingResponse =
      zio.aws.accessanalyzer.model
        .GetFindingResponse(finding.map(value => value.asEditable))
    def finding: Option[zio.aws.accessanalyzer.model.Finding.ReadOnly]
    def getFinding
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.Finding.ReadOnly] =
      AwsError.unwrapOptionField("finding", finding)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse
  ) extends zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly {
    override val finding
        : Option[zio.aws.accessanalyzer.model.Finding.ReadOnly] = scala
      .Option(impl.finding())
      .map(value => zio.aws.accessanalyzer.model.Finding.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse
  ): zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly = new Wrapper(
    impl
  )
}
