package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GeneratedPolicyResult(
    generatedPolicies: Option[
      Iterable[zio.aws.accessanalyzer.model.GeneratedPolicy]
    ] = None,
    properties: zio.aws.accessanalyzer.model.GeneratedPolicyProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult = {
    import GeneratedPolicyResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
      .builder()
      .optionallyWith(
        generatedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatedPolicies)
      .properties(properties.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly =
    zio.aws.accessanalyzer.model.GeneratedPolicyResult.wrap(buildAwsValue())
}
object GeneratedPolicyResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GeneratedPolicyResult =
      zio.aws.accessanalyzer.model.GeneratedPolicyResult(
        generatedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        properties.asEditable
      )
    def generatedPolicies
        : Option[List[zio.aws.accessanalyzer.model.GeneratedPolicy.ReadOnly]]
    def properties
        : zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly
    def getGeneratedPolicies: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.GeneratedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("generatedPolicies", generatedPolicies)
    def getProperties: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly
    ] = ZIO.succeed(properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
  ) extends zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly {
    override val generatedPolicies
        : Option[List[zio.aws.accessanalyzer.model.GeneratedPolicy.ReadOnly]] =
      scala
        .Option(impl.generatedPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.accessanalyzer.model.GeneratedPolicy.wrap(item)
          }.toList
        )
    override val properties
        : zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly =
      zio.aws.accessanalyzer.model.GeneratedPolicyProperties
        .wrap(impl.properties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
  ): zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly = new Wrapper(
    impl
  )
}
