package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteAnalyzerRequest(
    analyzerName: Name,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest = {
    import DeleteAnalyzerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.ReadOnly =
    zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.wrap(buildAwsValue())
}
object DeleteAnalyzerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.DeleteAnalyzerRequest =
      zio.aws.accessanalyzer.model
        .DeleteAnalyzerRequest(analyzerName, clientToken.map(value => value))
    def analyzerName: Name
    def clientToken: Option[String]
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
  ) extends zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
  ): zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.ReadOnly = new Wrapper(
    impl
  )
}
