package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Configuration(
    iamRole: Option[zio.aws.accessanalyzer.model.IamRoleConfiguration] = None,
    kmsKey: Option[zio.aws.accessanalyzer.model.KmsKeyConfiguration] = None,
    s3Bucket: Option[zio.aws.accessanalyzer.model.S3BucketConfiguration] = None,
    secretsManagerSecret: Option[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration
    ] = None,
    sqsQueue: Option[zio.aws.accessanalyzer.model.SqsQueueConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Configuration
      .builder()
      .optionallyWith(iamRole.map(value => value.buildAwsValue()))(_.iamRole)
      .optionallyWith(kmsKey.map(value => value.buildAwsValue()))(_.kmsKey)
      .optionallyWith(s3Bucket.map(value => value.buildAwsValue()))(_.s3Bucket)
      .optionallyWith(secretsManagerSecret.map(value => value.buildAwsValue()))(
        _.secretsManagerSecret
      )
      .optionallyWith(sqsQueue.map(value => value.buildAwsValue()))(_.sqsQueue)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Configuration.ReadOnly =
    zio.aws.accessanalyzer.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Configuration =
      zio.aws.accessanalyzer.model.Configuration(
        iamRole.map(value => value.asEditable),
        kmsKey.map(value => value.asEditable),
        s3Bucket.map(value => value.asEditable),
        secretsManagerSecret.map(value => value.asEditable),
        sqsQueue.map(value => value.asEditable)
      )
    def iamRole
        : Option[zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly]
    def kmsKey
        : Option[zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly]
    def s3Bucket
        : Option[zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly]
    def secretsManagerSecret: Option[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ]
    def sqsQueue
        : Option[zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly]
    def getIamRole: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("iamRole", iamRole)
    def getKmsKey: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getS3Bucket: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getSecretsManagerSecret: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("secretsManagerSecret", secretsManagerSecret)
    def getSqsQueue: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sqsQueue", sqsQueue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ) extends zio.aws.accessanalyzer.model.Configuration.ReadOnly {
    override val iamRole
        : Option[zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly] =
      scala
        .Option(impl.iamRole())
        .map(value =>
          zio.aws.accessanalyzer.model.IamRoleConfiguration.wrap(value)
        )
    override val kmsKey
        : Option[zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly] =
      scala
        .Option(impl.kmsKey())
        .map(value =>
          zio.aws.accessanalyzer.model.KmsKeyConfiguration.wrap(value)
        )
    override val s3Bucket
        : Option[zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly] =
      scala
        .Option(impl.s3Bucket())
        .map(value =>
          zio.aws.accessanalyzer.model.S3BucketConfiguration.wrap(value)
        )
    override val secretsManagerSecret: Option[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ] = scala
      .Option(impl.secretsManagerSecret())
      .map(value =>
        zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration
          .wrap(value)
      )
    override val sqsQueue
        : Option[zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly] =
      scala
        .Option(impl.sqsQueue())
        .map(value =>
          zio.aws.accessanalyzer.model.SqsQueueConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ): zio.aws.accessanalyzer.model.Configuration.ReadOnly = new Wrapper(impl)
}
