package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Location(
    path: Iterable[zio.aws.accessanalyzer.model.PathElement],
    span: zio.aws.accessanalyzer.model.Span
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Location = {
    import Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Location
      .builder()
      .path(path.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .span(span.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Location.ReadOnly =
    zio.aws.accessanalyzer.model.Location.wrap(buildAwsValue())
}
object Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Location =
      zio.aws.accessanalyzer.model.Location(
        path.map { item =>
          item.asEditable
        },
        span.asEditable
      )
    def path: List[zio.aws.accessanalyzer.model.PathElement.ReadOnly]
    def span: zio.aws.accessanalyzer.model.Span.ReadOnly
    def getPath: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.PathElement.ReadOnly
    ]] = ZIO.succeed(path)
    def getSpan: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.Span.ReadOnly] =
      ZIO.succeed(span)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Location
  ) extends zio.aws.accessanalyzer.model.Location.ReadOnly {
    override val path: List[zio.aws.accessanalyzer.model.PathElement.ReadOnly] =
      impl
        .path()
        .asScala
        .map { item =>
          zio.aws.accessanalyzer.model.PathElement.wrap(item)
        }
        .toList
    override val span: zio.aws.accessanalyzer.model.Span.ReadOnly =
      zio.aws.accessanalyzer.model.Span.wrap(impl.span())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Location
  ): zio.aws.accessanalyzer.model.Location.ReadOnly = new Wrapper(impl)
}
