package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Span(
    end: zio.aws.accessanalyzer.model.Position,
    start: zio.aws.accessanalyzer.model.Position
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Span = {
    import Span.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Span
      .builder()
      .end(end.buildAwsValue())
      .start(start.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Span.ReadOnly =
    zio.aws.accessanalyzer.model.Span.wrap(buildAwsValue())
}
object Span {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Span
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Span =
      zio.aws.accessanalyzer.model.Span(end.asEditable, start.asEditable)
    def end: zio.aws.accessanalyzer.model.Position.ReadOnly
    def start: zio.aws.accessanalyzer.model.Position.ReadOnly
    def getEnd
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.Position.ReadOnly] =
      ZIO.succeed(end)
    def getStart
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.Position.ReadOnly] =
      ZIO.succeed(start)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Span
  ) extends zio.aws.accessanalyzer.model.Span.ReadOnly {
    override val end: zio.aws.accessanalyzer.model.Position.ReadOnly =
      zio.aws.accessanalyzer.model.Position.wrap(impl.end())
    override val start: zio.aws.accessanalyzer.model.Position.ReadOnly =
      zio.aws.accessanalyzer.model.Position.wrap(impl.start())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Span
  ): zio.aws.accessanalyzer.model.Span.ReadOnly = new Wrapper(impl)
}
