package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{LearnMoreLink, IssueCode}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ValidatePolicyFinding(
    findingDetails: String,
    findingType: zio.aws.accessanalyzer.model.ValidatePolicyFindingType,
    issueCode: IssueCode,
    learnMoreLink: LearnMoreLink,
    locations: Iterable[zio.aws.accessanalyzer.model.Location]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFinding = {
    import ValidatePolicyFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFinding
      .builder()
      .findingDetails(findingDetails: java.lang.String)
      .findingType(findingType.unwrap)
      .issueCode(IssueCode.unwrap(issueCode): java.lang.String)
      .learnMoreLink(LearnMoreLink.unwrap(learnMoreLink): java.lang.String)
      .locations(locations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly =
    zio.aws.accessanalyzer.model.ValidatePolicyFinding.wrap(buildAwsValue())
}
object ValidatePolicyFinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ValidatePolicyFinding =
      zio.aws.accessanalyzer.model.ValidatePolicyFinding(
        findingDetails,
        findingType,
        issueCode,
        learnMoreLink,
        locations.map { item =>
          item.asEditable
        }
      )
    def findingDetails: String
    def findingType: zio.aws.accessanalyzer.model.ValidatePolicyFindingType
    def issueCode: IssueCode
    def learnMoreLink: LearnMoreLink
    def locations: List[zio.aws.accessanalyzer.model.Location.ReadOnly]
    def getFindingDetails: ZIO[Any, Nothing, String] =
      ZIO.succeed(findingDetails)
    def getFindingType: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.ValidatePolicyFindingType
    ] = ZIO.succeed(findingType)
    def getIssueCode: ZIO[Any, Nothing, IssueCode] = ZIO.succeed(issueCode)
    def getLearnMoreLink: ZIO[Any, Nothing, LearnMoreLink] =
      ZIO.succeed(learnMoreLink)
    def getLocations: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.Location.ReadOnly
    ]] = ZIO.succeed(locations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFinding
  ) extends zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly {
    override val findingDetails: String = impl.findingDetails(): String
    override val findingType
        : zio.aws.accessanalyzer.model.ValidatePolicyFindingType =
      zio.aws.accessanalyzer.model.ValidatePolicyFindingType
        .wrap(impl.findingType())
    override val issueCode: IssueCode =
      zio.aws.accessanalyzer.model.primitives.IssueCode(impl.issueCode())
    override val learnMoreLink: LearnMoreLink =
      zio.aws.accessanalyzer.model.primitives
        .LearnMoreLink(impl.learnMoreLink())
    override val locations
        : List[zio.aws.accessanalyzer.model.Location.ReadOnly] = impl
      .locations()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.Location.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFinding
  ): zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly = new Wrapper(
    impl
  )
}
