package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkOriginConfiguration(
    vpcConfiguration: Optional[zio.aws.accessanalyzer.model.VpcConfiguration] =
      Optional.Absent,
    internetConfiguration: Optional[
      zio.aws.accessanalyzer.model.InternetConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration = {
    import NetworkOriginConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
      .builder()
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        internetConfiguration.map(value => value.buildAwsValue())
      )(_.internetConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.NetworkOriginConfiguration
      .wrap(buildAwsValue())
}
object NetworkOriginConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.NetworkOriginConfiguration =
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration(
        vpcConfiguration.map(value => value.asEditable),
        internetConfiguration.map(value => value.asEditable)
      )
    def vpcConfiguration
        : Optional[zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly]
    def internetConfiguration
        : Optional[zio.aws.accessanalyzer.model.InternetConfiguration.ReadOnly]
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getInternetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.InternetConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("internetConfiguration", internetConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
  ) extends zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly {
    override val vpcConfiguration
        : Optional[zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.accessanalyzer.model.VpcConfiguration.wrap(value))
    override val internetConfiguration: Optional[
      zio.aws.accessanalyzer.model.InternetConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.internetConfiguration())
      .map(value =>
        zio.aws.accessanalyzer.model.InternetConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
  ): zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly =
    new Wrapper(impl)
}
