package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{KmsKeyPolicy, PolicyName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KmsKeyConfiguration(
    keyPolicies: Optional[Map[PolicyName, KmsKeyPolicy]] = Optional.Absent,
    grants: Optional[
      Iterable[zio.aws.accessanalyzer.model.KmsGrantConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration = {
    import KmsKeyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
      .builder()
      .optionallyWith(
        keyPolicies.map(value =>
          value
            .map({ case (key, value) =>
              (PolicyName.unwrap(key): java.lang.String) -> (KmsKeyPolicy
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.keyPolicies)
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.KmsKeyConfiguration.wrap(buildAwsValue())
}
object KmsKeyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.KmsKeyConfiguration =
      zio.aws.accessanalyzer.model.KmsKeyConfiguration(
        keyPolicies.map(value => value),
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyPolicies: Optional[Map[PolicyName, KmsKeyPolicy]]
    def grants: Optional[
      List[zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly]
    ]
    def getKeyPolicies: ZIO[Any, AwsError, Map[PolicyName, KmsKeyPolicy]] =
      AwsError.unwrapOptionField("keyPolicies", keyPolicies)
    def getGrants: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("grants", grants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
  ) extends zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly {
    override val keyPolicies: Optional[Map[PolicyName, KmsKeyPolicy]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPolicies())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.accessanalyzer.model.primitives.PolicyName(
                key
              ) -> zio.aws.accessanalyzer.model.primitives.KmsKeyPolicy(value)
            })
            .toMap
        )
    override val grants: Optional[
      List[zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.KmsGrantConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
  ): zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
