package zio.aws.accessanalyzer
import zio.prelude.Subtype
import zio.aws.accessanalyzer.model.primitives.{
  KmsKeyPolicy,
  RdsDbClusterSnapshotAccountId,
  KmsConstraintsKey,
  RdsDbSnapshotAttributeName,
  PolicyName,
  ConfigurationsMapKey,
  RdsDbSnapshotAccountId,
  AccessPointArn,
  RdsDbClusterSnapshotAttributeName,
  FindingId,
  EbsUserId,
  KmsConstraintsValue,
  EbsGroup
}
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessPointArn extends Subtype[String]
    type AccessPointArn =
      zio.aws.accessanalyzer.model.primitives.AccessPointArn.Type
    object AccessPointPolicy extends Subtype[String]
    type AccessPointPolicy =
      zio.aws.accessanalyzer.model.primitives.AccessPointPolicy.Type
    object AccessPreviewFindingId extends Subtype[String]
    type AccessPreviewFindingId =
      zio.aws.accessanalyzer.model.primitives.AccessPreviewFindingId.Type
    object AccessPreviewId extends Subtype[String]
    type AccessPreviewId =
      zio.aws.accessanalyzer.model.primitives.AccessPreviewId.Type
    object AclCanonicalId extends Subtype[String]
    type AclCanonicalId =
      zio.aws.accessanalyzer.model.primitives.AclCanonicalId.Type
    object AclUri extends Subtype[String]
    type AclUri = zio.aws.accessanalyzer.model.primitives.AclUri.Type
    object AnalyzerArn extends Subtype[String]
    type AnalyzerArn = zio.aws.accessanalyzer.model.primitives.AnalyzerArn.Type
    object CloudTrailArn extends Subtype[String]
    type CloudTrailArn =
      zio.aws.accessanalyzer.model.primitives.CloudTrailArn.Type
    object ConfigurationsMapKey extends Subtype[String]
    type ConfigurationsMapKey =
      zio.aws.accessanalyzer.model.primitives.ConfigurationsMapKey.Type
    object EbsGroup extends Subtype[String]
    type EbsGroup = zio.aws.accessanalyzer.model.primitives.EbsGroup.Type
    object EbsSnapshotDataEncryptionKeyId extends Subtype[String]
    type EbsSnapshotDataEncryptionKeyId =
      zio.aws.accessanalyzer.model.primitives.EbsSnapshotDataEncryptionKeyId.Type
    object EbsUserId extends Subtype[String]
    type EbsUserId = zio.aws.accessanalyzer.model.primitives.EbsUserId.Type
    object EcrRepositoryPolicy extends Subtype[String]
    type EcrRepositoryPolicy =
      zio.aws.accessanalyzer.model.primitives.EcrRepositoryPolicy.Type
    object EfsFileSystemPolicy extends Subtype[String]
    type EfsFileSystemPolicy =
      zio.aws.accessanalyzer.model.primitives.EfsFileSystemPolicy.Type
    object FindingId extends Subtype[String]
    type FindingId = zio.aws.accessanalyzer.model.primitives.FindingId.Type
    object GranteePrincipal extends Subtype[String]
    type GranteePrincipal =
      zio.aws.accessanalyzer.model.primitives.GranteePrincipal.Type
    object IamTrustPolicy extends Subtype[String]
    type IamTrustPolicy =
      zio.aws.accessanalyzer.model.primitives.IamTrustPolicy.Type
    type Integer = Int
    object IssueCode extends Subtype[String]
    type IssueCode = zio.aws.accessanalyzer.model.primitives.IssueCode.Type
    object IssuingAccount extends Subtype[String]
    type IssuingAccount =
      zio.aws.accessanalyzer.model.primitives.IssuingAccount.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.accessanalyzer.model.primitives.JobId.Type
    object KmsConstraintsKey extends Subtype[String]
    type KmsConstraintsKey =
      zio.aws.accessanalyzer.model.primitives.KmsConstraintsKey.Type
    object KmsConstraintsValue extends Subtype[String]
    type KmsConstraintsValue =
      zio.aws.accessanalyzer.model.primitives.KmsConstraintsValue.Type
    object KmsKeyPolicy extends Subtype[String]
    type KmsKeyPolicy =
      zio.aws.accessanalyzer.model.primitives.KmsKeyPolicy.Type
    object LearnMoreLink extends Subtype[String]
    type LearnMoreLink =
      zio.aws.accessanalyzer.model.primitives.LearnMoreLink.Type
    object ListPolicyGenerationsRequestMaxResultsInteger extends Subtype[Int]
    type ListPolicyGenerationsRequestMaxResultsInteger =
      zio.aws.accessanalyzer.model.primitives.ListPolicyGenerationsRequestMaxResultsInteger.Type
    object Name extends Subtype[String]
    type Name = zio.aws.accessanalyzer.model.primitives.Name.Type
    object PolicyDocument extends Subtype[String]
    type PolicyDocument =
      zio.aws.accessanalyzer.model.primitives.PolicyDocument.Type
    object PolicyName extends Subtype[String]
    type PolicyName = zio.aws.accessanalyzer.model.primitives.PolicyName.Type
    object PrincipalArn extends Subtype[String]
    type PrincipalArn =
      zio.aws.accessanalyzer.model.primitives.PrincipalArn.Type
    object RdsDbClusterSnapshotAccountId extends Subtype[String]
    type RdsDbClusterSnapshotAccountId =
      zio.aws.accessanalyzer.model.primitives.RdsDbClusterSnapshotAccountId.Type
    object RdsDbClusterSnapshotAttributeName extends Subtype[String]
    type RdsDbClusterSnapshotAttributeName =
      zio.aws.accessanalyzer.model.primitives.RdsDbClusterSnapshotAttributeName.Type
    object RdsDbClusterSnapshotKmsKeyId extends Subtype[String]
    type RdsDbClusterSnapshotKmsKeyId =
      zio.aws.accessanalyzer.model.primitives.RdsDbClusterSnapshotKmsKeyId.Type
    object RdsDbSnapshotAccountId extends Subtype[String]
    type RdsDbSnapshotAccountId =
      zio.aws.accessanalyzer.model.primitives.RdsDbSnapshotAccountId.Type
    object RdsDbSnapshotAttributeName extends Subtype[String]
    type RdsDbSnapshotAttributeName =
      zio.aws.accessanalyzer.model.primitives.RdsDbSnapshotAttributeName.Type
    object RdsDbSnapshotKmsKeyId extends Subtype[String]
    type RdsDbSnapshotKmsKeyId =
      zio.aws.accessanalyzer.model.primitives.RdsDbSnapshotKmsKeyId.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.accessanalyzer.model.primitives.ResourceArn.Type
    object RetiringPrincipal extends Subtype[String]
    type RetiringPrincipal =
      zio.aws.accessanalyzer.model.primitives.RetiringPrincipal.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.accessanalyzer.model.primitives.RoleArn.Type
    object S3BucketPolicy extends Subtype[String]
    type S3BucketPolicy =
      zio.aws.accessanalyzer.model.primitives.S3BucketPolicy.Type
    object SecretsManagerSecretKmsId extends Subtype[String]
    type SecretsManagerSecretKmsId =
      zio.aws.accessanalyzer.model.primitives.SecretsManagerSecretKmsId.Type
    object SecretsManagerSecretPolicy extends Subtype[String]
    type SecretsManagerSecretPolicy =
      zio.aws.accessanalyzer.model.primitives.SecretsManagerSecretPolicy.Type
    object SnsTopicPolicy extends Subtype[String]
    type SnsTopicPolicy =
      zio.aws.accessanalyzer.model.primitives.SnsTopicPolicy.Type
    object SqsQueuePolicy extends Subtype[String]
    type SqsQueuePolicy =
      zio.aws.accessanalyzer.model.primitives.SqsQueuePolicy.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.accessanalyzer.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.accessanalyzer.model.primitives.Token.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.accessanalyzer.model.primitives.VpcId.Type
  }
  type AccessPreviewFindingsList =
    List[zio.aws.accessanalyzer.model.AccessPreviewFinding]
  type AccessPreviewsList =
    List[zio.aws.accessanalyzer.model.AccessPreviewSummary]
  type ActionList = List[String]
  type AnalyzedResourcesList =
    List[zio.aws.accessanalyzer.model.AnalyzedResourceSummary]
  type AnalyzersList = List[zio.aws.accessanalyzer.model.AnalyzerSummary]
  type ArchiveRulesList = List[zio.aws.accessanalyzer.model.ArchiveRuleSummary]
  type ConditionKeyMap = Map[String, String]
  type ConfigurationsMap =
    Map[ConfigurationsMapKey, zio.aws.accessanalyzer.model.Configuration]
  type EbsGroupList = List[EbsGroup]
  type EbsUserIdList = List[EbsUserId]
  type FilterCriteriaMap = Map[String, zio.aws.accessanalyzer.model.Criterion]
  type FindingIdList = List[FindingId]
  type FindingSourceList = List[zio.aws.accessanalyzer.model.FindingSource]
  type FindingsList = List[zio.aws.accessanalyzer.model.FindingSummary]
  type GeneratedPolicyList = List[zio.aws.accessanalyzer.model.GeneratedPolicy]
  type InlineArchiveRulesList =
    List[zio.aws.accessanalyzer.model.InlineArchiveRule]
  type KmsConstraintsMap = Map[KmsConstraintsKey, KmsConstraintsValue]
  type KmsGrantConfigurationsList =
    List[zio.aws.accessanalyzer.model.KmsGrantConfiguration]
  type KmsGrantOperationsList =
    List[zio.aws.accessanalyzer.model.KmsGrantOperation]
  type KmsKeyPoliciesMap = Map[PolicyName, KmsKeyPolicy]
  type LocationList = List[zio.aws.accessanalyzer.model.Location]
  type PathElementList = List[zio.aws.accessanalyzer.model.PathElement]
  type PolicyGenerationList =
    List[zio.aws.accessanalyzer.model.PolicyGeneration]
  type PrincipalMap = Map[String, String]
  type RdsDbClusterSnapshotAccountIdsList = List[RdsDbClusterSnapshotAccountId]
  type RdsDbClusterSnapshotAttributesMap = Map[
    RdsDbClusterSnapshotAttributeName,
    zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
  ]
  type RdsDbSnapshotAccountIdsList = List[RdsDbSnapshotAccountId]
  type RdsDbSnapshotAttributesMap = Map[
    RdsDbSnapshotAttributeName,
    zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue
  ]
  type RegionList = List[String]
  type S3AccessPointConfigurationsMap =
    Map[AccessPointArn, zio.aws.accessanalyzer.model.S3AccessPointConfiguration]
  type S3BucketAclGrantConfigurationsList =
    List[zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration]
  type SharedViaList = List[String]
  type TagKeys = List[String]
  type TagsMap = Map[String, String]
  type TrailList = List[zio.aws.accessanalyzer.model.Trail]
  type TrailPropertiesList = List[zio.aws.accessanalyzer.model.TrailProperties]
  type ValidatePolicyFindingList =
    List[zio.aws.accessanalyzer.model.ValidatePolicyFinding]
  type ValueList = List[String]
}
