package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Integer, Token, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListArchiveRulesRequest(
    analyzerName: Name,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest = {
    import ListArchiveRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListArchiveRulesRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListArchiveRulesRequest.wrap(buildAwsValue())
}
object ListArchiveRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListArchiveRulesRequest =
      zio.aws.accessanalyzer.model.ListArchiveRulesRequest(
        analyzerName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def analyzerName: Name
    def nextToken: Optional[Token]
    def maxResults: Optional[Integer]
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest
  ) extends zio.aws.accessanalyzer.model.ListArchiveRulesRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest
  ): zio.aws.accessanalyzer.model.ListArchiveRulesRequest.ReadOnly =
    new Wrapper(impl)
}
