package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait AccessPreviewStatusReasonCode {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode
}
object AccessPreviewStatusReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode
  ): zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode.INVALID_CONFIGURATION =>
      val r = INVALID_CONFIGURATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode.INTERNAL_ERROR
  }
  case object INVALID_CONFIGURATION
      extends zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode.INVALID_CONFIGURATION
  }
}
