package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.RdsDbSnapshotAccountId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RdsDbSnapshotAttributeValue(
    accountIds: Optional[Iterable[RdsDbSnapshotAccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotAttributeValue = {
    import RdsDbSnapshotAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotAttributeValue
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            RdsDbSnapshotAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue.ReadOnly =
    zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue
      .wrap(buildAwsValue())
}
object RdsDbSnapshotAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue =
      zio.aws.accessanalyzer.model
        .RdsDbSnapshotAttributeValue(accountIds.map(value => value))
    def accountIds: Optional[List[RdsDbSnapshotAccountId]]
    def getAccountIds: ZIO[Any, AwsError, List[RdsDbSnapshotAccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotAttributeValue
  ) extends zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue.ReadOnly {
    override val accountIds: Optional[List[RdsDbSnapshotAccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.accessanalyzer.model.primitives.RdsDbSnapshotAccountId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotAttributeValue
  ): zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue.ReadOnly =
    new Wrapper(impl)
}
