package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait FindingSourceType {
  def unwrap
      : software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType
}
object FindingSourceType {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType
  ): zio.aws.accessanalyzer.model.FindingSourceType = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.POLICY =>
      val r = POLICY
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.BUCKET_ACL =>
      val r = BUCKET_ACL
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.S3_ACCESS_POINT =>
      val r = S3_ACCESS_POINT
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.S3_ACCESS_POINT_ACCOUNT =>
      val r = S3_ACCESS_POINT_ACCOUNT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.FindingSourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object POLICY extends zio.aws.accessanalyzer.model.FindingSourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.POLICY
  }
  case object BUCKET_ACL
      extends zio.aws.accessanalyzer.model.FindingSourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.BUCKET_ACL
  }
  case object S3_ACCESS_POINT
      extends zio.aws.accessanalyzer.model.FindingSourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.S3_ACCESS_POINT
  }
  case object S3_ACCESS_POINT_ACCOUNT
      extends zio.aws.accessanalyzer.model.FindingSourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType.S3_ACCESS_POINT_ACCOUNT
  }
}
