package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteAnalyzerRequest(
    analyzerName: Name,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest = {
    import DeleteAnalyzerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.ReadOnly =
    zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.wrap(buildAwsValue())
}
object DeleteAnalyzerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.DeleteAnalyzerRequest =
      zio.aws.accessanalyzer.model
        .DeleteAnalyzerRequest(analyzerName, clientToken.map(value => value))
    def analyzerName: Name
    def clientToken: Optional[String]
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
  ) extends zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest
  ): zio.aws.accessanalyzer.model.DeleteAnalyzerRequest.ReadOnly = new Wrapper(
    impl
  )
}
