package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.Type
  ): zio.aws.accessanalyzer.model.Type = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Type.ACCOUNT =>
      val r = ACCOUNT
      r
    case software.amazon.awssdk.services.accessanalyzer.model.Type.ORGANIZATION =>
      val r = ORGANIZATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.accessanalyzer.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Type =
      software.amazon.awssdk.services.accessanalyzer.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT extends zio.aws.accessanalyzer.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Type =
      software.amazon.awssdk.services.accessanalyzer.model.Type.ACCOUNT
  }
  case object ORGANIZATION extends zio.aws.accessanalyzer.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.Type =
      software.amazon.awssdk.services.accessanalyzer.model.Type.ORGANIZATION
  }
}
