package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{AnalyzerArn, AccessPreviewId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAccessPreviewRequest(
    accessPreviewId: AccessPreviewId,
    analyzerArn: AnalyzerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest = {
    import GetAccessPreviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest
      .builder()
      .accessPreviewId(
        AccessPreviewId.unwrap(accessPreviewId): java.lang.String
      )
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.GetAccessPreviewRequest.ReadOnly =
    zio.aws.accessanalyzer.model.GetAccessPreviewRequest.wrap(buildAwsValue())
}
object GetAccessPreviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetAccessPreviewRequest =
      zio.aws.accessanalyzer.model
        .GetAccessPreviewRequest(accessPreviewId, analyzerArn)
    def accessPreviewId: AccessPreviewId
    def analyzerArn: AnalyzerArn
    def getAccessPreviewId: ZIO[Any, Nothing, AccessPreviewId] =
      ZIO.succeed(accessPreviewId)
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest
  ) extends zio.aws.accessanalyzer.model.GetAccessPreviewRequest.ReadOnly {
    override val accessPreviewId: AccessPreviewId =
      zio.aws.accessanalyzer.model.primitives
        .AccessPreviewId(impl.accessPreviewId())
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest
  ): zio.aws.accessanalyzer.model.GetAccessPreviewRequest.ReadOnly =
    new Wrapper(impl)
}
