package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Integer, Token, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnalyzedResourcesRequest(
    analyzerArn: AnalyzerArn,
    resourceType: Optional[zio.aws.accessanalyzer.model.ResourceType] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest = {
    import ListAnalyzedResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest
      .wrap(buildAwsValue())
}
object ListAnalyzedResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest =
      zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest(
        analyzerArn,
        resourceType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def analyzerArn: AnalyzerArn
    def resourceType: Optional[zio.aws.accessanalyzer.model.ResourceType]
    def nextToken: Optional[Token]
    def maxResults: Optional[Integer]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
  ) extends zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val resourceType
        : Optional[zio.aws.accessanalyzer.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.accessanalyzer.model.ResourceType.wrap(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
  ): zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
