package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{Timestamp, Name, AnalyzerArn}
import scala.jdk.CollectionConverters._
final case class AnalyzerSummary(
    arn: AnalyzerArn,
    name: Name,
    `type`: zio.aws.accessanalyzer.model.Type,
    createdAt: Timestamp,
    lastResourceAnalyzed: Optional[String] = Optional.Absent,
    lastResourceAnalyzedAt: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    status: zio.aws.accessanalyzer.model.AnalyzerStatus,
    statusReason: Optional[zio.aws.accessanalyzer.model.StatusReason] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AnalyzerSummary = {
    import AnalyzerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzerSummary
      .builder()
      .arn(AnalyzerArn.unwrap(arn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        lastResourceAnalyzed.map(value => value: java.lang.String)
      )(_.lastResourceAnalyzed)
      .optionallyWith(
        lastResourceAnalyzedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastResourceAnalyzedAt)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value.buildAwsValue()))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly =
    zio.aws.accessanalyzer.model.AnalyzerSummary.wrap(buildAwsValue())
}
object AnalyzerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AnalyzerSummary =
      zio.aws.accessanalyzer.model.AnalyzerSummary(
        arn,
        name,
        `type`,
        createdAt,
        lastResourceAnalyzed.map(value => value),
        lastResourceAnalyzedAt.map(value => value),
        tags.map(value => value),
        status,
        statusReason.map(value => value.asEditable)
      )
    def arn: AnalyzerArn
    def name: Name
    def `type`: zio.aws.accessanalyzer.model.Type
    def createdAt: Timestamp
    def lastResourceAnalyzed: Optional[String]
    def lastResourceAnalyzedAt: Optional[Timestamp]
    def tags: Optional[Map[String, String]]
    def status: zio.aws.accessanalyzer.model.AnalyzerStatus
    def statusReason
        : Optional[zio.aws.accessanalyzer.model.StatusReason.ReadOnly]
    def getArn: ZIO[Any, Nothing, AnalyzerArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.Type] =
      ZIO.succeed(`type`)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastResourceAnalyzed: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastResourceAnalyzed", lastResourceAnalyzed)
    def getLastResourceAnalyzedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastResourceAnalyzedAt", lastResourceAnalyzedAt)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.AnalyzerStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.StatusReason.ReadOnly
    ] = AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzerSummary
  ) extends zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly {
    override val arn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.arn())
    override val name: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.name())
    override val `type`: zio.aws.accessanalyzer.model.Type =
      zio.aws.accessanalyzer.model.Type.wrap(impl.`type`())
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val lastResourceAnalyzed: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastResourceAnalyzed())
      .map(value => value: String)
    override val lastResourceAnalyzedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastResourceAnalyzedAt())
        .map(value => zio.aws.accessanalyzer.model.primitives.Timestamp(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val status: zio.aws.accessanalyzer.model.AnalyzerStatus =
      zio.aws.accessanalyzer.model.AnalyzerStatus.wrap(impl.status())
    override val statusReason
        : Optional[zio.aws.accessanalyzer.model.StatusReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value => zio.aws.accessanalyzer.model.StatusReason.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzerSummary
  ): zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly = new Wrapper(impl)
}
