package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetArchiveRuleResponse(
    archiveRule: zio.aws.accessanalyzer.model.ArchiveRuleSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse = {
    import GetArchiveRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse
      .builder()
      .archiveRule(archiveRule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly =
    zio.aws.accessanalyzer.model.GetArchiveRuleResponse.wrap(buildAwsValue())
}
object GetArchiveRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetArchiveRuleResponse =
      zio.aws.accessanalyzer.model
        .GetArchiveRuleResponse(archiveRule.asEditable)
    def archiveRule: zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
    def getArchiveRule: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
    ] = ZIO.succeed(archiveRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse
  ) extends zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly {
    override val archiveRule
        : zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly =
      zio.aws.accessanalyzer.model.ArchiveRuleSummary.wrap(impl.archiveRule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse
  ): zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly = new Wrapper(
    impl
  )
}
