package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.CloudTrailArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrailProperties(
    cloudTrailArn: CloudTrailArn,
    regions: Optional[Iterable[String]] = Optional.Absent,
    allRegions: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.TrailProperties = {
    import TrailProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
      .builder()
      .cloudTrailArn(CloudTrailArn.unwrap(cloudTrailArn): java.lang.String)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(allRegions.map(value => value: java.lang.Boolean))(
        _.allRegions
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.TrailProperties.ReadOnly =
    zio.aws.accessanalyzer.model.TrailProperties.wrap(buildAwsValue())
}
object TrailProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.TrailProperties =
      zio.aws.accessanalyzer.model.TrailProperties(
        cloudTrailArn,
        regions.map(value => value),
        allRegions.map(value => value)
      )
    def cloudTrailArn: CloudTrailArn
    def regions: Optional[List[String]]
    def allRegions: Optional[Boolean]
    def getCloudTrailArn: ZIO[Any, Nothing, CloudTrailArn] =
      ZIO.succeed(cloudTrailArn)
    def getRegions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("regions", regions)
    def getAllRegions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allRegions", allRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
  ) extends zio.aws.accessanalyzer.model.TrailProperties.ReadOnly {
    override val cloudTrailArn: CloudTrailArn =
      zio.aws.accessanalyzer.model.primitives
        .CloudTrailArn(impl.cloudTrailArn())
    override val regions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allRegions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allRegions())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
  ): zio.aws.accessanalyzer.model.TrailProperties.ReadOnly = new Wrapper(impl)
}
