package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{AccessPointArn, S3BucketPolicy}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3BucketConfiguration(
    bucketPolicy: Optional[S3BucketPolicy] = Optional.Absent,
    bucketAclGrants: Optional[
      Iterable[zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration]
    ] = Optional.Absent,
    bucketPublicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
    ] = Optional.Absent,
    accessPoints: Optional[Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration = {
    import S3BucketConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
      .builder()
      .optionallyWith(
        bucketPolicy.map(value =>
          S3BucketPolicy.unwrap(value): java.lang.String
        )
      )(_.bucketPolicy)
      .optionallyWith(
        bucketAclGrants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bucketAclGrants)
      .optionallyWith(
        bucketPublicAccessBlock.map(value => value.buildAwsValue())
      )(_.bucketPublicAccessBlock)
      .optionallyWith(
        accessPoints.map(value =>
          value
            .map({ case (key, value) =>
              (AccessPointArn.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.accessPoints)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.S3BucketConfiguration.wrap(buildAwsValue())
}
object S3BucketConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.S3BucketConfiguration =
      zio.aws.accessanalyzer.model.S3BucketConfiguration(
        bucketPolicy.map(value => value),
        bucketAclGrants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bucketPublicAccessBlock.map(value => value.asEditable),
        accessPoints.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def bucketPolicy: Optional[S3BucketPolicy]
    def bucketAclGrants: Optional[
      List[zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly]
    ]
    def bucketPublicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ]
    def accessPoints: Optional[Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly
    ]]
    def getBucketPolicy: ZIO[Any, AwsError, S3BucketPolicy] =
      AwsError.unwrapOptionField("bucketPolicy", bucketPolicy)
    def getBucketAclGrants: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("bucketAclGrants", bucketAclGrants)
    def getBucketPublicAccessBlock: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketPublicAccessBlock",
      bucketPublicAccessBlock
    )
    def getAccessPoints: ZIO[Any, AwsError, Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("accessPoints", accessPoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
  ) extends zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly {
    override val bucketPolicy: Optional[S3BucketPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPolicy())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.S3BucketPolicy(value)
      )
    override val bucketAclGrants: Optional[
      List[zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketAclGrants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.wrap(item)
        }.toList
      )
    override val bucketPublicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPublicAccessBlock())
      .map(value =>
        zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
          .wrap(value)
      )
    override val accessPoints: Optional[Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.accessanalyzer.model.primitives.AccessPointArn(
              key
            ) -> zio.aws.accessanalyzer.model.S3AccessPointConfiguration
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
  ): zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
