package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPolicyGenerationsResponse(
    policyGenerations: Iterable[zio.aws.accessanalyzer.model.PolicyGeneration],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse = {
    import ListPolicyGenerationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
      .builder()
      .policyGenerations(policyGenerations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse
      .wrap(buildAwsValue())
}
object ListPolicyGenerationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse =
      zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse(
        policyGenerations.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def policyGenerations
        : List[zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly]
    def nextToken: Optional[Token]
    def getPolicyGenerations: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly
    ]] = ZIO.succeed(policyGenerations)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
  ) extends zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly {
    override val policyGenerations
        : List[zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly] = impl
      .policyGenerations()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.PolicyGeneration.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
  ): zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly =
    new Wrapper(impl)
}
