package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.EfsFileSystemPolicy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EfsFileSystemConfiguration(
    fileSystemPolicy: Optional[EfsFileSystemPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.EfsFileSystemConfiguration = {
    import EfsFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.EfsFileSystemConfiguration
      .builder()
      .optionallyWith(
        fileSystemPolicy.map(value =>
          EfsFileSystemPolicy.unwrap(value): java.lang.String
        )
      )(_.fileSystemPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.EfsFileSystemConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.EfsFileSystemConfiguration
      .wrap(buildAwsValue())
}
object EfsFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.EfsFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.EfsFileSystemConfiguration =
      zio.aws.accessanalyzer.model
        .EfsFileSystemConfiguration(fileSystemPolicy.map(value => value))
    def fileSystemPolicy: Optional[EfsFileSystemPolicy]
    def getFileSystemPolicy: ZIO[Any, AwsError, EfsFileSystemPolicy] =
      AwsError.unwrapOptionField("fileSystemPolicy", fileSystemPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.EfsFileSystemConfiguration
  ) extends zio.aws.accessanalyzer.model.EfsFileSystemConfiguration.ReadOnly {
    override val fileSystemPolicy: Optional[EfsFileSystemPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemPolicy())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives.EfsFileSystemPolicy(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.EfsFileSystemConfiguration
  ): zio.aws.accessanalyzer.model.EfsFileSystemConfiguration.ReadOnly =
    new Wrapper(impl)
}
