package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Timestamp, Name}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ArchiveRuleSummary(
    ruleName: Name,
    filter: Map[String, zio.aws.accessanalyzer.model.Criterion],
    createdAt: Timestamp,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary = {
    import ArchiveRuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
      .builder()
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .filter(
        filter
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly =
    zio.aws.accessanalyzer.model.ArchiveRuleSummary.wrap(buildAwsValue())
}
object ArchiveRuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ArchiveRuleSummary =
      zio.aws.accessanalyzer.model.ArchiveRuleSummary(
        ruleName,
        filter.map({ case (key, value) =>
          key -> value.asEditable
        }),
        createdAt,
        updatedAt
      )
    def ruleName: Name
    def filter: Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
    def getFilter: ZIO[Any, Nothing, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = ZIO.succeed(filter)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
  ) extends zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly {
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
    override val filter
        : Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly] = impl
      .filter()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
      })
      .toMap
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
  ): zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly = new Wrapper(
    impl
  )
}
