package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGeneratedPolicyResponse(
    jobDetails: zio.aws.accessanalyzer.model.JobDetails,
    generatedPolicyResult: zio.aws.accessanalyzer.model.GeneratedPolicyResult
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse = {
    import GetGeneratedPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
      .builder()
      .jobDetails(jobDetails.buildAwsValue())
      .generatedPolicyResult(generatedPolicyResult.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly =
    zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse
      .wrap(buildAwsValue())
}
object GetGeneratedPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse =
      zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse(
        jobDetails.asEditable,
        generatedPolicyResult.asEditable
      )
    def jobDetails: zio.aws.accessanalyzer.model.JobDetails.ReadOnly
    def generatedPolicyResult
        : zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly
    def getJobDetails
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.JobDetails.ReadOnly] =
      ZIO.succeed(jobDetails)
    def getGeneratedPolicyResult: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly
    ] = ZIO.succeed(generatedPolicyResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
  ) extends zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly {
    override val jobDetails: zio.aws.accessanalyzer.model.JobDetails.ReadOnly =
      zio.aws.accessanalyzer.model.JobDetails.wrap(impl.jobDetails())
    override val generatedPolicyResult
        : zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly =
      zio.aws.accessanalyzer.model.GeneratedPolicyResult
        .wrap(impl.generatedPolicyResult())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
  ): zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
