package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.PrincipalArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GeneratedPolicyProperties(
    isComplete: Optional[Boolean] = Optional.Absent,
    principalArn: PrincipalArn,
    cloudTrailProperties: Optional[
      zio.aws.accessanalyzer.model.CloudTrailProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyProperties = {
    import GeneratedPolicyProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyProperties
      .builder()
      .optionallyWith(isComplete.map(value => value: java.lang.Boolean))(
        _.isComplete
      )
      .principalArn(PrincipalArn.unwrap(principalArn): java.lang.String)
      .optionallyWith(cloudTrailProperties.map(value => value.buildAwsValue()))(
        _.cloudTrailProperties
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly =
    zio.aws.accessanalyzer.model.GeneratedPolicyProperties.wrap(buildAwsValue())
}
object GeneratedPolicyProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GeneratedPolicyProperties =
      zio.aws.accessanalyzer.model.GeneratedPolicyProperties(
        isComplete.map(value => value),
        principalArn,
        cloudTrailProperties.map(value => value.asEditable)
      )
    def isComplete: Optional[Boolean]
    def principalArn: PrincipalArn
    def cloudTrailProperties
        : Optional[zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly]
    def getIsComplete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isComplete", isComplete)
    def getPrincipalArn: ZIO[Any, Nothing, PrincipalArn] =
      ZIO.succeed(principalArn)
    def getCloudTrailProperties: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly
    ] = AwsError.unwrapOptionField("cloudTrailProperties", cloudTrailProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyProperties
  ) extends zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly {
    override val isComplete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isComplete())
      .map(value => value: Boolean)
    override val principalArn: PrincipalArn =
      zio.aws.accessanalyzer.model.primitives.PrincipalArn(impl.principalArn())
    override val cloudTrailProperties
        : Optional[zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudTrailProperties())
        .map(value =>
          zio.aws.accessanalyzer.model.CloudTrailProperties.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyProperties
  ): zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly =
    new Wrapper(impl)
}
