package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.EcrRepositoryPolicy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EcrRepositoryConfiguration(
    repositoryPolicy: Optional[EcrRepositoryPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.EcrRepositoryConfiguration = {
    import EcrRepositoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.EcrRepositoryConfiguration
      .builder()
      .optionallyWith(
        repositoryPolicy.map(value =>
          EcrRepositoryPolicy.unwrap(value): java.lang.String
        )
      )(_.repositoryPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.EcrRepositoryConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.EcrRepositoryConfiguration
      .wrap(buildAwsValue())
}
object EcrRepositoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.EcrRepositoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.EcrRepositoryConfiguration =
      zio.aws.accessanalyzer.model
        .EcrRepositoryConfiguration(repositoryPolicy.map(value => value))
    def repositoryPolicy: Optional[EcrRepositoryPolicy]
    def getRepositoryPolicy: ZIO[Any, AwsError, EcrRepositoryPolicy] =
      AwsError.unwrapOptionField("repositoryPolicy", repositoryPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.EcrRepositoryConfiguration
  ) extends zio.aws.accessanalyzer.model.EcrRepositoryConfiguration.ReadOnly {
    override val repositoryPolicy: Optional[EcrRepositoryPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryPolicy())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives.EcrRepositoryPolicy(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.EcrRepositoryConfiguration
  ): zio.aws.accessanalyzer.model.EcrRepositoryConfiguration.ReadOnly =
    new Wrapper(impl)
}
