package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{Timestamp, ResourceArn}
import scala.jdk.CollectionConverters._
final case class AnalyzedResource(
    resourceArn: ResourceArn,
    resourceType: zio.aws.accessanalyzer.model.ResourceType,
    createdAt: Timestamp,
    analyzedAt: Timestamp,
    updatedAt: Timestamp,
    isPublic: Boolean,
    actions: Optional[Iterable[String]] = Optional.Absent,
    sharedVia: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[zio.aws.accessanalyzer.model.FindingStatus] =
      Optional.Absent,
    resourceOwnerAccount: String,
    error: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource = {
    import AnalyzedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .resourceType(resourceType.unwrap)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .analyzedAt(Timestamp.unwrap(analyzedAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .isPublic(isPublic: java.lang.Boolean)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(
        sharedVia.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sharedVia)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .resourceOwnerAccount(resourceOwnerAccount: java.lang.String)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly =
    zio.aws.accessanalyzer.model.AnalyzedResource.wrap(buildAwsValue())
}
object AnalyzedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AnalyzedResource =
      zio.aws.accessanalyzer.model.AnalyzedResource(
        resourceArn,
        resourceType,
        createdAt,
        analyzedAt,
        updatedAt,
        isPublic,
        actions.map(value => value),
        sharedVia.map(value => value),
        status.map(value => value),
        resourceOwnerAccount,
        error.map(value => value)
      )
    def resourceArn: ResourceArn
    def resourceType: zio.aws.accessanalyzer.model.ResourceType
    def createdAt: Timestamp
    def analyzedAt: Timestamp
    def updatedAt: Timestamp
    def isPublic: Boolean
    def actions: Optional[List[String]]
    def sharedVia: Optional[List[String]]
    def status: Optional[zio.aws.accessanalyzer.model.FindingStatus]
    def resourceOwnerAccount: String
    def error: Optional[String]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getAnalyzedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(analyzedAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getIsPublic: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isPublic)
    def getActions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("actions", actions)
    def getSharedVia: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sharedVia", sharedVia)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.FindingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResourceOwnerAccount: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceOwnerAccount)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
  ) extends zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.accessanalyzer.model.primitives.ResourceArn(impl.resourceArn())
    override val resourceType: zio.aws.accessanalyzer.model.ResourceType =
      zio.aws.accessanalyzer.model.ResourceType.wrap(impl.resourceType())
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val analyzedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.analyzedAt())
    override val updatedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.updatedAt())
    override val isPublic: Boolean = impl.isPublic(): Boolean
    override val actions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sharedVia: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sharedVia())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Optional[zio.aws.accessanalyzer.model.FindingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.accessanalyzer.model.FindingStatus.wrap(value))
    override val resourceOwnerAccount: String =
      impl.resourceOwnerAccount(): String
    override val error: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
  ): zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly = new Wrapper(impl)
}
