package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait AclPermission {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.AclPermission
}
object AclPermission {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.AclPermission
  ): zio.aws.accessanalyzer.model.AclPermission = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.AclPermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AclPermission.READ =>
      val r = READ
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AclPermission.WRITE =>
      val r = WRITE
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AclPermission.READ_ACP =>
      val r = READ_ACP
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AclPermission.WRITE_ACP =>
      val r = WRITE_ACP
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AclPermission.FULL_CONTROL =>
      val r = FULL_CONTROL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.AclPermission {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AclPermission =
      software.amazon.awssdk.services.accessanalyzer.model.AclPermission.UNKNOWN_TO_SDK_VERSION
  }
  case object READ extends zio.aws.accessanalyzer.model.AclPermission {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AclPermission =
      software.amazon.awssdk.services.accessanalyzer.model.AclPermission.READ
  }
  case object WRITE extends zio.aws.accessanalyzer.model.AclPermission {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AclPermission =
      software.amazon.awssdk.services.accessanalyzer.model.AclPermission.WRITE
  }
  case object READ_ACP extends zio.aws.accessanalyzer.model.AclPermission {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AclPermission =
      software.amazon.awssdk.services.accessanalyzer.model.AclPermission.READ_ACP
  }
  case object WRITE_ACP extends zio.aws.accessanalyzer.model.AclPermission {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AclPermission =
      software.amazon.awssdk.services.accessanalyzer.model.AclPermission.WRITE_ACP
  }
  case object FULL_CONTROL extends zio.aws.accessanalyzer.model.AclPermission {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AclPermission =
      software.amazon.awssdk.services.accessanalyzer.model.AclPermission.FULL_CONTROL
  }
}
