package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Integer, Token}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnalyzersRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    `type`: Optional[zio.aws.accessanalyzer.model.Type] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest = {
    import ListAnalyzersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ListAnalyzersRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListAnalyzersRequest.wrap(buildAwsValue())
}
object ListAnalyzersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListAnalyzersRequest =
      zio.aws.accessanalyzer.model.ListAnalyzersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        `type`.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[Integer]
    def `type`: Optional[zio.aws.accessanalyzer.model.Type]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getType: ZIO[Any, AwsError, zio.aws.accessanalyzer.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest
  ) extends zio.aws.accessanalyzer.model.ListAnalyzersRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val `type`: Optional[zio.aws.accessanalyzer.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.accessanalyzer.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest
  ): zio.aws.accessanalyzer.model.ListAnalyzersRequest.ReadOnly = new Wrapper(
    impl
  )
}
