package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAnalyzerRequest(
    analyzerName: Name,
    `type`: zio.aws.accessanalyzer.model.Type,
    archiveRules: Optional[
      Iterable[zio.aws.accessanalyzer.model.InlineArchiveRule]
    ] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest = {
    import CreateAnalyzerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        archiveRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.archiveRules)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.CreateAnalyzerRequest.ReadOnly =
    zio.aws.accessanalyzer.model.CreateAnalyzerRequest.wrap(buildAwsValue())
}
object CreateAnalyzerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CreateAnalyzerRequest =
      zio.aws.accessanalyzer.model.CreateAnalyzerRequest(
        analyzerName,
        `type`,
        archiveRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def analyzerName: Name
    def `type`: zio.aws.accessanalyzer.model.Type
    def archiveRules: Optional[
      List[zio.aws.accessanalyzer.model.InlineArchiveRule.ReadOnly]
    ]
    def tags: Optional[Map[String, String]]
    def clientToken: Optional[String]
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getType: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.Type] =
      ZIO.succeed(`type`)
    def getArchiveRules: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.InlineArchiveRule.ReadOnly
    ]] = AwsError.unwrapOptionField("archiveRules", archiveRules)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest
  ) extends zio.aws.accessanalyzer.model.CreateAnalyzerRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val `type`: zio.aws.accessanalyzer.model.Type =
      zio.aws.accessanalyzer.model.Type.wrap(impl.`type`())
    override val archiveRules: Optional[
      List[zio.aws.accessanalyzer.model.InlineArchiveRule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.InlineArchiveRule.wrap(item)
        }.toList
      )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest
  ): zio.aws.accessanalyzer.model.CreateAnalyzerRequest.ReadOnly = new Wrapper(
    impl
  )
}
