package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{ResourceArn, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartResourceScanRequest(
    analyzerArn: AnalyzerArn,
    resourceArn: ResourceArn,
    resourceOwnerAccount: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest = {
    import StartResourceScanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        resourceOwnerAccount.map(value => value: java.lang.String)
      )(_.resourceOwnerAccount)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.StartResourceScanRequest.ReadOnly =
    zio.aws.accessanalyzer.model.StartResourceScanRequest.wrap(buildAwsValue())
}
object StartResourceScanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.StartResourceScanRequest =
      zio.aws.accessanalyzer.model.StartResourceScanRequest(
        analyzerArn,
        resourceArn,
        resourceOwnerAccount.map(value => value)
      )
    def analyzerArn: AnalyzerArn
    def resourceArn: ResourceArn
    def resourceOwnerAccount: Optional[String]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getResourceOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerAccount", resourceOwnerAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest
  ) extends zio.aws.accessanalyzer.model.StartResourceScanRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val resourceArn: ResourceArn =
      zio.aws.accessanalyzer.model.primitives.ResourceArn(impl.resourceArn())
    override val resourceOwnerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwnerAccount())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest
  ): zio.aws.accessanalyzer.model.StartResourceScanRequest.ReadOnly =
    new Wrapper(impl)
}
