package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  ConfigurationsMapKey,
  AnalyzerArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAccessPreviewRequest(
    analyzerArn: AnalyzerArn,
    configurations: Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration
    ],
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest = {
    import CreateAccessPreviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .configurations(
        configurations
          .map({ case (key, value) =>
            (ConfigurationsMapKey.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.CreateAccessPreviewRequest.ReadOnly =
    zio.aws.accessanalyzer.model.CreateAccessPreviewRequest
      .wrap(buildAwsValue())
}
object CreateAccessPreviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CreateAccessPreviewRequest =
      zio.aws.accessanalyzer.model.CreateAccessPreviewRequest(
        analyzerArn,
        configurations.map({ case (key, value) =>
          key -> value.asEditable
        }),
        clientToken.map(value => value)
      )
    def analyzerArn: AnalyzerArn
    def configurations: Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration.ReadOnly
    ]
    def clientToken: Optional[String]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getConfigurations: ZIO[Any, Nothing, Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration.ReadOnly
    ]] = ZIO.succeed(configurations)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest
  ) extends zio.aws.accessanalyzer.model.CreateAccessPreviewRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val configurations: Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration.ReadOnly
    ] = impl
      .configurations()
      .asScala
      .map({ case (key, value) =>
        zio.aws.accessanalyzer.model.primitives.ConfigurationsMapKey(
          key
        ) -> zio.aws.accessanalyzer.model.Configuration.wrap(value)
      })
      .toMap
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest
  ): zio.aws.accessanalyzer.model.CreateAccessPreviewRequest.ReadOnly =
    new Wrapper(impl)
}
