package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{Timestamp, RoleArn}
import scala.jdk.CollectionConverters._
final case class CloudTrailDetails(
    trails: Iterable[zio.aws.accessanalyzer.model.Trail],
    accessRole: RoleArn,
    startTime: Timestamp,
    endTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails = {
    import CloudTrailDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
      .builder()
      .trails(trails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .accessRole(RoleArn.unwrap(accessRole): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly =
    zio.aws.accessanalyzer.model.CloudTrailDetails.wrap(buildAwsValue())
}
object CloudTrailDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CloudTrailDetails =
      zio.aws.accessanalyzer.model.CloudTrailDetails(
        trails.map { item =>
          item.asEditable
        },
        accessRole,
        startTime,
        endTime.map(value => value)
      )
    def trails: List[zio.aws.accessanalyzer.model.Trail.ReadOnly]
    def accessRole: RoleArn
    def startTime: Timestamp
    def endTime: Optional[Timestamp]
    def getTrails
        : ZIO[Any, Nothing, List[zio.aws.accessanalyzer.model.Trail.ReadOnly]] =
      ZIO.succeed(trails)
    def getAccessRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(accessRole)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
  ) extends zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly {
    override val trails: List[zio.aws.accessanalyzer.model.Trail.ReadOnly] =
      impl
        .trails()
        .asScala
        .map { item =>
          zio.aws.accessanalyzer.model.Trail.wrap(item)
        }
        .toList
    override val accessRole: RoleArn =
      zio.aws.accessanalyzer.model.primitives.RoleArn(impl.accessRole())
    override val startTime: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.startTime())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.accessanalyzer.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
  ): zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly = new Wrapper(impl)
}
