package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{ResourceArn, AnalyzerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAnalyzedResourceRequest(
    analyzerArn: AnalyzerArn,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest = {
    import GetAnalyzedResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.GetAnalyzedResourceRequest.ReadOnly =
    zio.aws.accessanalyzer.model.GetAnalyzedResourceRequest
      .wrap(buildAwsValue())
}
object GetAnalyzedResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetAnalyzedResourceRequest =
      zio.aws.accessanalyzer.model
        .GetAnalyzedResourceRequest(analyzerArn, resourceArn)
    def analyzerArn: AnalyzerArn
    def resourceArn: ResourceArn
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest
  ) extends zio.aws.accessanalyzer.model.GetAnalyzedResourceRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val resourceArn: ResourceArn =
      zio.aws.accessanalyzer.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest
  ): zio.aws.accessanalyzer.model.GetAnalyzedResourceRequest.ReadOnly =
    new Wrapper(impl)
}
