package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PathElement(
    index: Optional[Integer] = Optional.Absent,
    key: Optional[String] = Optional.Absent,
    substring: Optional[zio.aws.accessanalyzer.model.Substring] =
      Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.PathElement = {
    import PathElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.PathElement
      .builder()
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(substring.map(value => value.buildAwsValue()))(
        _.substring
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.PathElement.ReadOnly =
    zio.aws.accessanalyzer.model.PathElement.wrap(buildAwsValue())
}
object PathElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.PathElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.PathElement =
      zio.aws.accessanalyzer.model.PathElement(
        index.map(value => value),
        key.map(value => value),
        substring.map(value => value.asEditable),
        value.map(value => value)
      )
    def index: Optional[Integer]
    def key: Optional[String]
    def substring: Optional[zio.aws.accessanalyzer.model.Substring.ReadOnly]
    def value: Optional[String]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getSubstring
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.Substring.ReadOnly] =
      AwsError.unwrapOptionField("substring", substring)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.PathElement
  ) extends zio.aws.accessanalyzer.model.PathElement.ReadOnly {
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val substring
        : Optional[zio.aws.accessanalyzer.model.Substring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substring())
        .map(value => zio.aws.accessanalyzer.model.Substring.wrap(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.PathElement
  ): zio.aws.accessanalyzer.model.PathElement.ReadOnly = new Wrapper(impl)
}
