package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{Timestamp, JobId}
import scala.jdk.CollectionConverters._
final case class JobDetails(
    jobId: JobId,
    status: zio.aws.accessanalyzer.model.JobStatus,
    startedOn: Timestamp,
    completedOn: Optional[Timestamp] = Optional.Absent,
    jobError: Optional[zio.aws.accessanalyzer.model.JobError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.JobDetails = {
    import JobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.JobDetails
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .status(status.unwrap)
      .startedOn(Timestamp.unwrap(startedOn): Instant)
      .optionallyWith(
        completedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedOn)
      .optionallyWith(jobError.map(value => value.buildAwsValue()))(_.jobError)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.JobDetails.ReadOnly =
    zio.aws.accessanalyzer.model.JobDetails.wrap(buildAwsValue())
}
object JobDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.JobDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.JobDetails =
      zio.aws.accessanalyzer.model.JobDetails(
        jobId,
        status,
        startedOn,
        completedOn.map(value => value),
        jobError.map(value => value.asEditable)
      )
    def jobId: JobId
    def status: zio.aws.accessanalyzer.model.JobStatus
    def startedOn: Timestamp
    def completedOn: Optional[Timestamp]
    def jobError: Optional[zio.aws.accessanalyzer.model.JobError.ReadOnly]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStatus: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.JobStatus] =
      ZIO.succeed(status)
    def getStartedOn: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startedOn)
    def getCompletedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedOn", completedOn)
    def getJobError
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.JobError.ReadOnly] =
      AwsError.unwrapOptionField("jobError", jobError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.JobDetails
  ) extends zio.aws.accessanalyzer.model.JobDetails.ReadOnly {
    override val jobId: JobId =
      zio.aws.accessanalyzer.model.primitives.JobId(impl.jobId())
    override val status: zio.aws.accessanalyzer.model.JobStatus =
      zio.aws.accessanalyzer.model.JobStatus.wrap(impl.status())
    override val startedOn: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.startedOn())
    override val completedOn: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completedOn())
      .map(value => zio.aws.accessanalyzer.model.primitives.Timestamp(value))
    override val jobError
        : Optional[zio.aws.accessanalyzer.model.JobError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobError())
        .map(value => zio.aws.accessanalyzer.model.JobError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.JobDetails
  ): zio.aws.accessanalyzer.model.JobDetails.ReadOnly = new Wrapper(impl)
}
