package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait FindingStatus {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.FindingStatus
}
object FindingStatus {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.FindingStatus
  ): zio.aws.accessanalyzer.model.FindingStatus = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.ARCHIVED =>
      val r = ARCHIVED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.RESOLVED =>
      val r = RESOLVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingStatus =
      software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.accessanalyzer.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingStatus =
      software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.ACTIVE
  }
  case object ARCHIVED extends zio.aws.accessanalyzer.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingStatus =
      software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.ARCHIVED
  }
  case object RESOLVED extends zio.aws.accessanalyzer.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingStatus =
      software.amazon.awssdk.services.accessanalyzer.model.FindingStatus.RESOLVED
  }
}
