package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  KmsConstraintsValue,
  KmsConstraintsKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KmsGrantConstraints(
    encryptionContextEquals: Optional[
      Map[KmsConstraintsKey, KmsConstraintsValue]
    ] = Optional.Absent,
    encryptionContextSubset: Optional[
      Map[KmsConstraintsKey, KmsConstraintsValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConstraints = {
    import KmsGrantConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConstraints
      .builder()
      .optionallyWith(
        encryptionContextEquals.map(value =>
          value
            .map({ case (key, value) =>
              (KmsConstraintsKey
                .unwrap(key): java.lang.String) -> (KmsConstraintsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContextEquals)
      .optionallyWith(
        encryptionContextSubset.map(value =>
          value
            .map({ case (key, value) =>
              (KmsConstraintsKey
                .unwrap(key): java.lang.String) -> (KmsConstraintsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContextSubset)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly =
    zio.aws.accessanalyzer.model.KmsGrantConstraints.wrap(buildAwsValue())
}
object KmsGrantConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.KmsGrantConstraints =
      zio.aws.accessanalyzer.model.KmsGrantConstraints(
        encryptionContextEquals.map(value => value),
        encryptionContextSubset.map(value => value)
      )
    def encryptionContextEquals
        : Optional[Map[KmsConstraintsKey, KmsConstraintsValue]]
    def encryptionContextSubset
        : Optional[Map[KmsConstraintsKey, KmsConstraintsValue]]
    def getEncryptionContextEquals
        : ZIO[Any, AwsError, Map[KmsConstraintsKey, KmsConstraintsValue]] =
      AwsError.unwrapOptionField(
        "encryptionContextEquals",
        encryptionContextEquals
      )
    def getEncryptionContextSubset
        : ZIO[Any, AwsError, Map[KmsConstraintsKey, KmsConstraintsValue]] =
      AwsError.unwrapOptionField(
        "encryptionContextSubset",
        encryptionContextSubset
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConstraints
  ) extends zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly {
    override val encryptionContextEquals
        : Optional[Map[KmsConstraintsKey, KmsConstraintsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContextEquals())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.accessanalyzer.model.primitives.KmsConstraintsKey(
                key
              ) -> zio.aws.accessanalyzer.model.primitives
                .KmsConstraintsValue(value)
            })
            .toMap
        )
    override val encryptionContextSubset
        : Optional[Map[KmsConstraintsKey, KmsConstraintsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContextSubset())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.accessanalyzer.model.primitives.KmsConstraintsKey(
                key
              ) -> zio.aws.accessanalyzer.model.primitives
                .KmsConstraintsValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConstraints
  ): zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly = new Wrapper(
    impl
  )
}
