package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FindingSource(
    `type`: zio.aws.accessanalyzer.model.FindingSourceType,
    detail: Optional[zio.aws.accessanalyzer.model.FindingSourceDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.FindingSource = {
    import FindingSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.FindingSource
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(detail.map(value => value.buildAwsValue()))(_.detail)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.FindingSource.ReadOnly =
    zio.aws.accessanalyzer.model.FindingSource.wrap(buildAwsValue())
}
object FindingSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.FindingSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.FindingSource =
      zio.aws.accessanalyzer.model
        .FindingSource(`type`, detail.map(value => value.asEditable))
    def `type`: zio.aws.accessanalyzer.model.FindingSourceType
    def detail
        : Optional[zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly]
    def getType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingSourceType] =
      ZIO.succeed(`type`)
    def getDetail: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly
    ] = AwsError.unwrapOptionField("detail", detail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSource
  ) extends zio.aws.accessanalyzer.model.FindingSource.ReadOnly {
    override val `type`: zio.aws.accessanalyzer.model.FindingSourceType =
      zio.aws.accessanalyzer.model.FindingSourceType.wrap(impl.`type`())
    override val detail
        : Optional[zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detail())
        .map(value =>
          zio.aws.accessanalyzer.model.FindingSourceDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSource
  ): zio.aws.accessanalyzer.model.FindingSource.ReadOnly = new Wrapper(impl)
}
