package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SortCriteria(
    attributeName: Optional[String] = Optional.Absent,
    orderBy: Optional[zio.aws.accessanalyzer.model.OrderBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.SortCriteria = {
    import SortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.SortCriteria
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.SortCriteria.ReadOnly =
    zio.aws.accessanalyzer.model.SortCriteria.wrap(buildAwsValue())
}
object SortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.SortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.SortCriteria =
      zio.aws.accessanalyzer.model.SortCriteria(
        attributeName.map(value => value),
        orderBy.map(value => value)
      )
    def attributeName: Optional[String]
    def orderBy: Optional[zio.aws.accessanalyzer.model.OrderBy]
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.accessanalyzer.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SortCriteria
  ) extends zio.aws.accessanalyzer.model.SortCriteria.ReadOnly {
    override val attributeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => value: String)
    override val orderBy: Optional[zio.aws.accessanalyzer.model.OrderBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderBy())
        .map(value => zio.aws.accessanalyzer.model.OrderBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SortCriteria
  ): zio.aws.accessanalyzer.model.SortCriteria.ReadOnly = new Wrapper(impl)
}
