package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Position(line: Integer, column: Integer, offset: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Position = {
    import Position.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Position
      .builder()
      .line(line: java.lang.Integer)
      .column(column: java.lang.Integer)
      .offset(offset: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Position.ReadOnly =
    zio.aws.accessanalyzer.model.Position.wrap(buildAwsValue())
}
object Position {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Position
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Position =
      zio.aws.accessanalyzer.model.Position(line, column, offset)
    def line: Integer
    def column: Integer
    def offset: Integer
    def getLine: ZIO[Any, Nothing, Integer] = ZIO.succeed(line)
    def getColumn: ZIO[Any, Nothing, Integer] = ZIO.succeed(column)
    def getOffset: ZIO[Any, Nothing, Integer] = ZIO.succeed(offset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Position
  ) extends zio.aws.accessanalyzer.model.Position.ReadOnly {
    override val line: Integer = impl.line(): Integer
    override val column: Integer = impl.column(): Integer
    override val offset: Integer = impl.offset(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Position
  ): zio.aws.accessanalyzer.model.Position.ReadOnly = new Wrapper(impl)
}
