package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait OrderBy {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.OrderBy
}
object OrderBy {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.OrderBy
  ): zio.aws.accessanalyzer.model.OrderBy = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.OrderBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.OrderBy.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.accessanalyzer.model.OrderBy.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion extends zio.aws.accessanalyzer.model.OrderBy {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.OrderBy =
      software.amazon.awssdk.services.accessanalyzer.model.OrderBy.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.accessanalyzer.model.OrderBy {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.OrderBy =
      software.amazon.awssdk.services.accessanalyzer.model.OrderBy.ASC
  }
  case object DESC extends zio.aws.accessanalyzer.model.OrderBy {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.OrderBy =
      software.amazon.awssdk.services.accessanalyzer.model.OrderBy.DESC
  }
}
